/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.villagers.json.adapters;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.nyfaria.numismaticoverhaul.NumismaticOverhaul;
import com.nyfaria.numismaticoverhaul.currency.CurrencyHelper;
import com.nyfaria.numismaticoverhaul.owostuff.util.RegistryAccess;
import com.nyfaria.numismaticoverhaul.villagers.json.TradeJsonAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.VillagerJsonHelper;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.NumOTrade;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SellMapAdapter
extends TradeJsonAdapter {
    @Override
    @NotNull
    public VillagerTrades.ItemListing deserialize(JsonObject json) {
        this.loadDefaultStats(json, true);
        VillagerJsonHelper.assertString(json, "structure");
        int price = json.get("price").getAsInt();
        ResourceLocation structure = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"structure"));
        return new Factory(price, structure, this.max_uses, this.villager_experience, this.price_multiplier);
    }

    private static class Factory
    implements VillagerTrades.ItemListing,
    NumOTrade {
        private final int price;
        private final ResourceLocation structureId;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public Factory(int price, ResourceLocation feature, int maxUses, int experience, float multiplier) {
            this.price = price;
            this.structureId = feature;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            Level level = entity.f_19853_;
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverWorld = (ServerLevel)level;
            Registry registry = serverWorld.m_5962_().m_175515_(Registry.f_235725_);
            Holder<ResourceLocation> feature = RegistryAccess.getEntry(registry, this.structureId);
            if (feature == null || feature.m_203543_().isEmpty()) {
                NumismaticOverhaul.LOGGER.error("Tried to create map to invalid structure " + this.structureId);
                return null;
            }
            Pair result = serverWorld.m_7726_().m_8481_().m_223037_(serverWorld, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{feature}), entity.m_20183_(), 1500, true);
            if (result == null) {
                return null;
            }
            BlockPos blockPos = (BlockPos)result.getFirst();
            MapDecoration.Type iconType = MapDecoration.Type.TARGET_X;
            if (feature.m_203373_(BuiltinStructures.f_209856_.m_135782_())) {
                iconType = MapDecoration.Type.MONUMENT;
            }
            if (feature.m_203373_(BuiltinStructures.f_209848_.m_135782_())) {
                iconType = MapDecoration.Type.MANSION;
            }
            if (feature.m_203373_(BuiltinStructures.f_209845_.m_135782_())) {
                iconType = MapDecoration.Type.TARGET_POINT;
            }
            ItemStack itemStack = MapItem.m_42886_((Level)serverWorld, (int)blockPos.m_123341_(), (int)blockPos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
            MapItem.m_42850_((ServerLevel)serverWorld, (ItemStack)itemStack);
            MapItemSavedData.m_77925_((ItemStack)itemStack, (BlockPos)blockPos, (String)"+", (MapDecoration.Type)iconType);
            itemStack.m_41714_((Component)Component.m_237115_((String)("filled_map." + ((ResourceKey)feature.m_203543_().get()).m_135782_().m_135815_().toLowerCase(Locale.ROOT))));
            return new MerchantOffer(CurrencyHelper.getClosest(this.price), new ItemStack((ItemLike)Items.f_42676_), itemStack, this.maxUses, this.experience, this.multiplier);
        }
    }
}

